<%
Option Explicit 

    'Demo of how to use the error handler in an ASP application
    'and also how to simulate VB's On Error GoTo.

    'In calling code, use inline error handling.
    On Error Resume Next

    Main

    'Any error in Main will jump to the next line.
    If Err.Number = 0 Then Response.End

    'An error has been detected, drop through to the HTML below.
%>

<html>
<head>
<title>Error Handler Demo</title>
</head>
<body>

<h1>ASPTest Fatal Error</h1>

<table width="637">
  <tr>
    <td width="137"><b>Error Number: </b></td>
    <td width="486"><%=Err.Number%></td>
  </tr>
  <tr>
    <td width="137" valign="top"><b>Error Description:</b></td>
    <td width="486" valign="top"><%=Err.Description%></td>
  </tr>
  <tr>
    <td width="137" valign="top"><b>Error Source:</b></td>
    <td width="486" valign="top"><%=Err.Source%></td>
  </tr>
</table>
</body>
</html>

<%
Sub Main
Dim objTest
    
    'In called code, do not use an error handler.
    'In the event of an error the routine exits and control returns to the caller.

    Response.Write "Create object <br>"
    Set objTest = Server.CreateObject("ASPErrorTest.ASPTest")

    Response.Write "Call method <br>"
    objTest.CalledRoutine1	'This routine causes a fatal error condition.

    Response.Write "You should not see this line <br>"
    Set objTest = Nothing

End Sub
%>
